#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'


require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative 'request_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'

describe '[Story #VAR-11064: Request Status Change - Display in VAOS (Includes resolved status)]' do

  include OracleUtility
  include DateUtility
  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @detail = RequestAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    TITLE = "Appointments/Requests"

    #this will not work in CI but the data will be reset in the jenkins
    @patientID = "1006088937V099668"
    @patientID2 = "1113138327"
    deletePatientData(@patientID)
    deletePatientData(@patientID2)
    @common.loginEndsOnHome(pw_redacted)
    @common.waitWhileSpinnerPresent
    @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
    @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)

  end

  after(:all) do
    deletePatientData(@patientID)
    deletePatientData(@patientID2)
    deleteAllRequestData
    @driver.close
  end

  context 'AC#VAR-11165 | TC#VAR11166: Request Status Change - Display in VAOS (Includes resolved status)' do

    it 'Verify Details on Request Resolved as Resolved/Scheduled Outside of Scheduling Manager' do
      deleteAllRequestData()
      insertRequestsData("Resolved", OPTOMETRY, "523A5", "408", "Brockton VAMC", "DETCODE20")
      @common.waitWhileSpinnerPresent
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.clickRequest(0)
      @common.waitWhileSpinnerPresent
      @detail.request_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.status_element.text).to eq("Status: Resolved")
      expect(@detail.status_desc_element.text).to eq("Your appointment has been scheduled.")
    end

    it 'Verify Details on Request Resolved as Resolved/Specialty Not Available ' do
      @detail.clickBackButton
      deleteAllRequestData()
      insertRequestsData("Resolved", PRIMARY_CARE, "523A5", "408", "Brockton VAMC", "DETCODE21")
      @common.waitWhileSpinnerPresent
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.clickRequest(0)
      @common.waitWhileSpinnerPresent
      @detail.request_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.status_element.text).to eq("Status: Resolved")
      expect(@detail.status_desc_element.text).to eq("The appointment type you requested is not available for online scheduling requests. VA will contact you to schedule an appointment. If VA has not contacted you within 24 hours, please contact your facility. View VA Facility phone numbers")
    end

    it 'Verify Details on Request Resolved as Cancelled/Unable to Reach Veteran' do
      @detail.clickBackButton
      deleteAllRequestData()
      insertRequestsData("Cancelled", AUDIOLOGY, "523A5", "408", "Brockton VAMC", "DETCODE23")
      @common.waitWhileSpinnerPresent
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.clickRequest(0)
      @common.waitWhileSpinnerPresent
      @detail.request_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.status_element.text).to eq("Status: Cancelled")
      expect(@detail.status_desc_element.text).to eq("We were unable to contact you to discuss your appointment. We apologize for not being able to book this request for an appointment. You can call the facility to discuss scheduling options for your current need or you can start a new appointment request using this application.")
    end

    it 'Verify Details on Request Resolved as Cancelled/Cancelled At Veteran Request' do
      @detail.clickBackButton
      deleteAllRequestData()
      insertRequestsData("Cancelled", MENTAL_HEALTH, "523A5", "408", "Brockton VAMC", "DETCODE22")
      @common.waitWhileSpinnerPresent
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.clickRequest(0)
      @common.waitWhileSpinnerPresent
      @detail.request_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.status_element.text).to eq("Status: Cancelled")
      expect(@detail.status_desc_element.text).to eq("Your appointment request has been cancelled at your request.")
    end

    it 'Verify Details on Request Resolved as Cancelled/Other' do
      @detail.clickBackButton
      deleteAllRequestData()
      insertRequestsData("Cancelled", EXPRESS_CARE, "523A5", "CR1", "Brockton VAMC", "DETCODE24")
      @common.waitWhileSpinnerPresent
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.clickRequest(0)
      @common.waitWhileSpinnerPresent
      @detail.request_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.status_element.text).to eq("Status: Cancelled")
      expect(@detail.status_desc_element.text).to eq("Your request has been cancelled. Please contact the facility if you have questions regarding this request or scheduling a related appointment.")
    end
  end

end